# -*- coding: utf-8 -*-
import importlib, types
mods = ["ar_operator_core","ar_operator_core.ops","ar_operator_core.core","ar_operator_core.operators"]
last=None
for m in mods:
    try:
        mod = importlib.import_module(m); break
    except Exception as e:
        last = e
else:
    raise AssertionError(f"cannot import core module; last={last}")
def _get(mod,name): return getattr(mod,name,None)
def _callable(x): return callable(x) or isinstance(x,(type,types.FunctionType))
def test_primitives():
    missing=[]
    for tag in ["F","S","X","C"]:
        if not _callable(_get(mod,tag)): missing.append(tag)
    phi = _get(mod,"Φ") or _get(mod,"Phi")
    if not _callable(phi): missing.append("Φ/Phi")
    assert not missing, f"Missing/non-callable: {missing}"
